from setuptools import setup

# read the contents of your README file
from os import path
this_directory = path.abspath(path.dirname(__file__))
with open(path.join(this_directory, 'README.md'), encoding='utf-8') as f:
    long_description = f.read()

def local_scheme(version):
    return ""

setup(
    name='skodaconnect',
    version='1.0.17',
    description='Communicate with Skoda Connect',
    author='lendy007',
    author_email='lendik@gmail.com',
    url='https://github.com/lendy007/skodaconnect',
    long_description=long_description,
    long_description_content_type='text/markdown',
    py_modules=[
        "skodaconnect",
        "dashboardskoda",
        "utilities",
        "__init__"
    ],
    provides=["skodaconnect"],
    install_requires=list(open("requirements.txt").read().strip().split("\n")),
    #use_scm_version=True,
    use_scm_version={"local_scheme": local_scheme},
    setup_requires=[
        'setuptools_scm',
        'pytest>=5,<6',
    ]
)
