/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.cover.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.ft.cover.Coverage;
import ucar.nc2.ft.cover.CoverageCS;
import ucar.nc2.ft.cover.CoverageDataset;
import ucar.nc2.ft.cover.impl.CoverageCSFactory;
import ucar.nc2.ft.cover.impl.CoverageImpl;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.unidata.geoloc.LatLonRect;

public class CoverageDatasetImpl
implements CoverageDataset {
    private NetcdfDataset ds;
    private CoverageCS.Type type;
    private List<Coverage> coverages;
    private List<CoverageDataset.CoverageSet> coverageSets = new ArrayList<CoverageDataset.CoverageSet>();
    private LatLonRect llbbMax = null;
    private CalendarDateRange dateRangeMax = null;

    public CoverageDatasetImpl(NetcdfDataset ds, Formatter parseInfo) {
        this.ds = ds;
        CoverageCSFactory fac = new CoverageCSFactory();
        this.type = fac.classify(ds, parseInfo);
        this.coverageSets = new ArrayList<CoverageDataset.CoverageSet>(ds.getVariables().size());
        for (CoordinateSystem cs : ds.getCoordinateSystems()) {
            CoverageCS ccs = CoverageCSFactory.make(ds, cs, parseInfo);
            if (ccs == null) continue;
            CoverageSetImpl cset = new CoverageSetImpl(ccs);
            this.coverageSets.add(cset);
        }
        this.coverages = new ArrayList<Coverage>(ds.getVariables().size());
        for (Variable v : ds.getVariables()) {
            VariableEnhanced ve = (VariableEnhanced)((Object)v);
            List<CoordinateSystem> css = ve.getCoordinateSystems();
            if (css.size() == 0) continue;
            Collections.sort(css, new Comparator<CoordinateSystem>(){

                @Override
                public int compare(CoordinateSystem o1, CoordinateSystem o2) {
                    return o2.getCoordinateAxes().size() - o1.getCoordinateAxes().size();
                }
            });
            CoordinateSystem cs = css.get(0);
            CoverageSetImpl cset = this.findCoverageSet(cs);
            if (cset == null) continue;
            CoverageImpl ci = new CoverageImpl(ds, cset.ccs, ve);
            cset.coverages.add(ci);
            this.coverages.add(ci);
        }
    }

    private CoverageSetImpl findCoverageSet(CoordinateSystem cs) {
        for (CoverageDataset.CoverageSet ccs : this.coverageSets) {
            if (!ccs.getCoverageCS().getName().equals(cs.getName())) continue;
            return (CoverageSetImpl)ccs;
        }
        return null;
    }

    private void makeRanges() {
        for (CoverageDataset.CoverageSet cset : this.getCoverageSets()) {
            CalendarDateRange dateRange;
            CoverageCS ccs = cset.getCoverageCS();
            LatLonRect llbb = ccs.getLatLonBoundingBox();
            if (this.llbbMax == null) {
                this.llbbMax = llbb;
            } else {
                this.llbbMax.extend(llbb);
            }
            if ((dateRange = ccs.getCalendarDateRange()) == null) continue;
            if (this.dateRangeMax == null) {
                this.dateRangeMax = dateRange;
                continue;
            }
            this.dateRangeMax.extend(dateRange);
        }
    }

    @Override
    public List<Coverage> getCoverages() {
        return this.coverages;
    }

    @Override
    public Coverage findCoverage(String name) {
        for (Coverage c : this.coverages) {
            if (!c.getFullName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public CoverageCS.Type getType() {
        return this.type;
    }

    @Override
    public List<CoverageDataset.CoverageSet> getCoverageSets() {
        return this.coverageSets;
    }

    @Override
    public FeatureType getFeatureType() {
        switch (this.type) {
            case Coverage: 
            case Curvilinear: 
            case Grid: {
                return FeatureType.GRID;
            }
            case Fmrc: {
                return FeatureType.FMRC;
            }
            case Swath: {
                return FeatureType.SWATH;
            }
        }
        return null;
    }

    @Override
    public String getTitle() {
        return this.ds.getTitle();
    }

    @Override
    public String getDescription() {
        String desc = this.ds.findAttValueIgnoreCase(null, "description", null);
        if (desc == null) {
            desc = this.ds.findAttValueIgnoreCase(null, "history", null);
        }
        return desc == null ? this.getLocation() : desc;
    }

    @Override
    public String getLocation() {
        return this.ds.getLocation();
    }

    @Override
    public CalendarDateRange getCalendarDateRange() {
        if (this.dateRangeMax == null) {
            this.makeRanges();
        }
        return this.dateRangeMax;
    }

    @Override
    public CalendarDate getCalendarDateStart() {
        if (this.dateRangeMax == null) {
            this.makeRanges();
        }
        return this.dateRangeMax == null ? null : this.dateRangeMax.getStart();
    }

    @Override
    public CalendarDate getCalendarDateEnd() {
        if (this.dateRangeMax == null) {
            this.makeRanges();
        }
        return this.dateRangeMax == null ? null : this.dateRangeMax.getEnd();
    }

    @Override
    public LatLonRect getBoundingBox() {
        if (this.llbbMax == null) {
            this.makeRanges();
        }
        return this.llbbMax;
    }

    @Override
    public void calcBounds() throws IOException {
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return this.ds.getGlobalAttributes();
    }

    @Override
    public Attribute findGlobalAttributeIgnoreCase(String name) {
        return this.ds.findGlobalAttribute(name);
    }

    @Override
    public List<VariableSimpleIF> getDataVariables() {
        ArrayList<VariableSimpleIF> datav = new ArrayList<VariableSimpleIF>(this.coverages.size());
        for (Coverage c : this.coverages) {
            datav.add(c);
        }
        return datav;
    }

    @Override
    public VariableSimpleIF getDataVariable(String shortName) {
        for (Coverage c : this.coverages) {
            if (!c.getShortName().equals(shortName)) continue;
            return c;
        }
        return null;
    }

    @Override
    public NetcdfFile getNetcdfFile() {
        return this.ds;
    }

    @Override
    public void close() throws IOException {
        this.ds.close();
    }

    @Override
    public void release() throws IOException {
        this.ds.release();
    }

    @Override
    public void reacquire() throws IOException {
        this.ds.reacquire();
    }

    @Override
    public long getLastModified() {
        return this.ds.getLastModified();
    }

    @Override
    public void setFileCache(FileCacheIF fileCache) {
        this.ds.setFileCache(fileCache);
    }

    @Override
    public void getDetailInfo(Formatter sf) {
        this.ds.getDetailInfo();
    }

    @Override
    public String getImplementationName() {
        return null;
    }

    @Override
    public DateRange getDateRange() {
        return this.getCalendarDateRange().toDateRange();
    }

    @Override
    public Date getStartDate() {
        CalendarDate cdate = this.getCalendarDateStart();
        return cdate == null ? null : cdate.toDate();
    }

    @Override
    public Date getEndDate() {
        CalendarDate cdate = this.getCalendarDateEnd();
        return cdate == null ? null : cdate.toDate();
    }

    private static class CoverageSetImpl
    implements CoverageDataset.CoverageSet {
        CoverageCS ccs;
        List<Coverage> coverages = new ArrayList<Coverage>();

        CoverageSetImpl(CoverageCS ccs) {
            this.ccs = ccs;
        }

        @Override
        public List<Coverage> getCoverages() {
            return this.coverages;
        }

        @Override
        public CoverageCS getCoverageCS() {
            return this.ccs;
        }
    }
}

