/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.io.File;
import net.jcip.annotations.ThreadSafe;
import thredds.inventory.MFile;
import ucar.unidata.util.StringUtil2;

@ThreadSafe
public class MFileOS
implements MFile {
    private final File file;
    private final long lastModified;
    private Object auxInfo;

    public static MFileOS getExistingFile(String filename) {
        if (filename == null) {
            return null;
        }
        File file2 = new File(filename);
        if (file2.exists()) {
            return new MFileOS(file2);
        }
        return null;
    }

    public MFileOS(File file2) {
        this.file = file2;
        this.lastModified = file2.lastModified();
    }

    public MFileOS(String filename) {
        this.file = new File(filename);
        this.lastModified = this.file.lastModified();
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public String getPath() {
        return StringUtil2.replace(this.file.getPath(), '\\', "/");
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public MFile getParent() {
        return new MFileOS(this.file.getParentFile());
    }

    @Override
    public int compareTo(MFile o) {
        return this.getPath().compareTo(o.getPath());
    }

    @Override
    public Object getAuxInfo() {
        return this.auxInfo;
    }

    @Override
    public void setAuxInfo(Object auxInfo) {
        this.auxInfo = auxInfo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MFileOS{");
        sb.append("file=").append(this.file.getPath());
        sb.append(", lastModified=").append(this.lastModified);
        sb.append('}');
        return sb.toString();
    }

    public File getFile() {
        return this.file;
    }
}

