/*
 * Decompiled with CFR 0.152.
 */
package org.perf4j.log4j;

import java.io.Flushable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;
import org.perf4j.GroupedTimingStatistics;
import org.perf4j.chart.GoogleChartGenerator;
import org.perf4j.chart.StatisticsChartGenerator;
import org.perf4j.helpers.MiscUtils;
import org.perf4j.helpers.StatsValueRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphingStatisticsAppender
extends AppenderSkeleton
implements AppenderAttachable,
Flushable {
    protected static final Map<String, GraphingStatisticsAppender> APPENDERS_BY_NAME = Collections.synchronizedMap(new LinkedHashMap());
    private String graphType = StatsValueRetriever.MEAN_VALUE_RETRIEVER.getValueName();
    private String tagNamesToGraph = null;
    private int dataPointsPerGraph = 20;
    private StatisticsChartGenerator chartGenerator;
    private AtomicLong numLoggedStatistics = new AtomicLong();
    private volatile boolean hasUnflushedData = false;
    private Level lastAppendedEventLevel = Level.INFO;
    private final AppenderAttachableImpl downstreamAppenders = new AppenderAttachableImpl();

    public String getGraphType() {
        return this.graphType;
    }

    public void setGraphType(String graphType) {
        this.graphType = graphType;
    }

    public String getTagNamesToGraph() {
        return this.tagNamesToGraph;
    }

    public void setTagNamesToGraph(String tagNamesToGraph) {
        this.tagNamesToGraph = tagNamesToGraph;
    }

    public int getDataPointsPerGraph() {
        return this.dataPointsPerGraph;
    }

    public void setDataPointsPerGraph(int dataPointsPerGraph) {
        if (dataPointsPerGraph <= 0) {
            throw new IllegalArgumentException("The DataPointsPerGraph option must be positive");
        }
        this.dataPointsPerGraph = dataPointsPerGraph;
    }

    public void activateOptions() {
        this.chartGenerator = this.createChartGenerator();
        if (this.getName() != null) {
            APPENDERS_BY_NAME.put(this.getName(), this);
        }
    }

    protected StatisticsChartGenerator createChartGenerator() {
        StatsValueRetriever statsValueRetriever = StatsValueRetriever.DEFAULT_RETRIEVERS.get(this.getGraphType());
        if (statsValueRetriever == null) {
            throw new RuntimeException("Unknown GraphType: " + this.getGraphType() + ". See the StatsValueRetriever class for the list of acceptable types.");
        }
        GoogleChartGenerator retVal = new GoogleChartGenerator(statsValueRetriever);
        if (this.getTagNamesToGraph() != null) {
            HashSet<String> enabledTags = new HashSet<String>(Arrays.asList(MiscUtils.splitAndTrim(this.getTagNamesToGraph(), ",")));
            retVal.setEnabledTags(enabledTags);
        }
        return retVal;
    }

    public StatisticsChartGenerator getChartGenerator() {
        return this.chartGenerator;
    }

    public static GraphingStatisticsAppender getAppenderByName(String appenderName) {
        return APPENDERS_BY_NAME.get(appenderName);
    }

    public static Collection<GraphingStatisticsAppender> getAllGraphingStatisticsAppenders() {
        return Collections.unmodifiableCollection(APPENDERS_BY_NAME.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppender(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            this.downstreamAppenders.addAppender(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            return this.downstreamAppenders.getAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Appender getAppender(String name) {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            return this.downstreamAppenders.getAppender(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAttached(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            return this.downstreamAppenders.isAttached(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            this.downstreamAppenders.removeAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            this.downstreamAppenders.removeAppender(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(String name) {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            this.downstreamAppenders.removeAppender(name);
        }
    }

    protected void append(LoggingEvent event) {
        Object logMessage = event.getMessage();
        if (logMessage instanceof GroupedTimingStatistics && this.chartGenerator != null) {
            this.chartGenerator.appendData((GroupedTimingStatistics)logMessage);
            this.hasUnflushedData = true;
            this.lastAppendedEventLevel = event.getLevel();
            if (this.numLoggedStatistics.incrementAndGet() % (long)this.getDataPointsPerGraph() == 0L) {
                this.flush();
            }
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            this.flush();
            Enumeration enumer = this.downstreamAppenders.getAllAppenders();
            while (enumer != null && enumer.hasMoreElements()) {
                Appender appender = (Appender)enumer.nextElement();
                appender.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            if (this.hasUnflushedData && this.downstreamAppenders.getAllAppenders() != null) {
                this.downstreamAppenders.appendLoopOnAppenders(new LoggingEvent(Logger.class.getName(), (Category)Logger.getLogger((String)"org.perf4j.TimingLogger"), System.currentTimeMillis(), (Priority)this.lastAppendedEventLevel, (Object)this.chartGenerator.getChartUrl(), null));
                this.hasUnflushedData = false;
            }
        }
    }
}

