/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.Macro;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.common.Location;
import loci.common.Region;
import loci.plugins.prefs.DoubleOption;
import loci.plugins.prefs.OptionsList;
import loci.plugins.prefs.StringOption;
import loci.plugins.util.LibraryChecker;

public class ImporterOptions
extends OptionsList {
    public static final String KEY_AUTOSCALE = "autoscale";
    public static final String KEY_COLOR_MODE = "colorMode";
    public static final String KEY_CONCATENATE = "concatenate";
    public static final String KEY_CROP = "crop";
    public static final String KEY_FIRST = "firstTime";
    public static final String KEY_FORCE_THUMBS = "forceThumbnails";
    public static final String KEY_GROUP_FILES = "groupFiles";
    public static final String KEY_UNGROUP_FILES = "ungroupFiles";
    public static final String KEY_ID = "id";
    public static final String KEY_LOCATION = "location";
    public static final String KEY_OPEN_ALL_SERIES = "openAllSeries";
    public static final String KEY_QUIET = "quiet";
    public static final String KEY_SHOW_METADATA = "showMetadata";
    public static final String KEY_SHOW_OME_XML = "showOMEXML";
    public static final String KEY_SHOW_ROIS = "showROIs";
    public static final String KEY_ROIS_MODE = "roiMode";
    public static final String KEY_SPECIFY_RANGES = "specifyRanges";
    public static final String KEY_SPLIT_Z = "splitFocalPlanes";
    public static final String KEY_SPLIT_T = "splitTimepoints";
    public static final String KEY_SPLIT_C = "splitWindows";
    public static final String KEY_STACK_FORMAT = "stackFormat";
    public static final String KEY_STACK_ORDER = "stackOrder";
    public static final String KEY_SWAP_DIMS = "swapDimensions";
    public static final String KEY_UPGRADE_CHECK = "upgradeCheck";
    public static final String KEY_VIRTUAL = "virtual";
    public static final String KEY_WINDOWLESS = "windowless";
    public static final String KEY_STITCH_TILES = "stitchTiles";
    public static final String KEY_MUST_GROUP = "mustGroup";
    public static final String COLOR_MODE_DEFAULT = "Default";
    public static final String COLOR_MODE_COMPOSITE = "Composite";
    public static final String COLOR_MODE_COLORIZED = "Colorized";
    public static final String COLOR_MODE_GRAYSCALE = "Grayscale";
    public static final String COLOR_MODE_CUSTOM = "Custom";
    public static final String LOCATION_LOCAL = "Local machine";
    public static final String LOCATION_HTTP = "Internet";
    public static final String LOCATION_OMERO = "OMERO";
    public static final String ROIS_MODE_MANAGER = "ROI manager";
    public static final String ROIS_MODE_OVERLAY = "Overlay";
    public static final String VIEW_NONE = "Metadata only";
    public static final String VIEW_STANDARD = "Standard ImageJ";
    public static final String VIEW_HYPERSTACK = "Hyperstack";
    public static final String VIEW_BROWSER = "Data Browser";
    public static final String VIEW_IMAGE_5D = "Image5D";
    public static final String VIEW_VIEW_5D = "View5D";
    private static final String CLASS_IMAGE_5D = "i5d.Image5D";
    private static final String CLASS_VIEW_5D = "view5d.View5D_";
    public static final String ORDER_DEFAULT = "Default";
    public static final String ORDER_XYZCT = "XYZCT";
    public static final String ORDER_XYZTC = "XYZTC";
    public static final String ORDER_XYCZT = "XYCZT";
    public static final String ORDER_XYTCZ = "XYTCZ";
    public static final String ORDER_XYCTZ = "XYCTZ";
    public static final String ORDER_XYTZC = "XYTZC";
    private static final Color[] DEFAULT_COLORS = new Color[]{Color.red, Color.green, Color.blue, Color.white, Color.cyan, Color.magenta, Color.yellow};
    private List<Boolean> seriesOn = new ArrayList<Boolean>();
    private List<String> inputOrder = new ArrayList<String>();
    private List<Integer> cBegin = new ArrayList<Integer>();
    private List<Integer> cEnd = new ArrayList<Integer>();
    private List<Integer> cStep = new ArrayList<Integer>();
    private List<Integer> zBegin = new ArrayList<Integer>();
    private List<Integer> zEnd = new ArrayList<Integer>();
    private List<Integer> zStep = new ArrayList<Integer>();
    private List<Integer> tBegin = new ArrayList<Integer>();
    private List<Integer> tEnd = new ArrayList<Integer>();
    private List<Integer> tStep = new ArrayList<Integer>();
    private List<Region> cropRegion = new ArrayList<Region>();
    private List<List<DoubleOption>> customColors = new ArrayList<List<DoubleOption>>();
    private boolean usePatternIds;

    public ImporterOptions() throws IOException {
        super("importer-options.txt", ImporterOptions.class);
        StringOption stackFormat = this.getStringOption(KEY_STACK_FORMAT);
        if (!LibraryChecker.checkClass(CLASS_IMAGE_5D)) {
            stackFormat.removePossible(VIEW_IMAGE_5D);
        }
        if (!LibraryChecker.checkClass(CLASS_VIEW_5D)) {
            stackFormat.removePossible(VIEW_VIEW_5D);
        }
    }

    public void parseArg(String arg) {
        if (arg == null || arg.length() == 0) {
            return;
        }
        if (new Location(arg).exists()) {
            this.setLocation(LOCATION_LOCAL);
            this.setId(arg);
            this.setQuiet(true);
        } else {
            this.parseOptions(arg);
        }
    }

    public void checkObsoleteOptions() {
        String macroOptions = Macro.getOptions();
        boolean mergeChannels = this.checkKey(macroOptions, "merge_channels");
        boolean rgbColorize = this.checkKey(macroOptions, "rgb_colorize");
        boolean customColorize = this.checkKey(macroOptions, "custom_colorize");
        if (mergeChannels) {
            this.setColorMode(COLOR_MODE_COMPOSITE);
        } else if (rgbColorize) {
            this.setColorMode(COLOR_MODE_COLORIZED);
        } else if (customColorize) {
            this.setColorMode(COLOR_MODE_CUSTOM);
        }
    }

    public String getAutoscaleInfo() {
        return this.getInfo(KEY_AUTOSCALE);
    }

    public boolean isAutoscale() {
        return this.isSet(KEY_AUTOSCALE);
    }

    public void setAutoscale(boolean b) {
        this.setValue(KEY_AUTOSCALE, b);
    }

    public String getColorModeInfo() {
        return this.getInfo(KEY_COLOR_MODE);
    }

    public String getColorMode() {
        return this.getValue(KEY_COLOR_MODE);
    }

    public String[] getColorModes() {
        return this.getPossible(KEY_COLOR_MODE);
    }

    public boolean isColorModeDefault() {
        return "Default".equals(this.getColorMode());
    }

    public boolean isColorModeComposite() {
        return COLOR_MODE_COMPOSITE.equals(this.getColorMode());
    }

    public boolean isColorModeColorized() {
        return COLOR_MODE_COLORIZED.equals(this.getColorMode());
    }

    public boolean isColorModeGrayscale() {
        return COLOR_MODE_GRAYSCALE.equals(this.getColorMode());
    }

    public boolean isColorModeCustom() {
        return COLOR_MODE_CUSTOM.equals(this.getColorMode());
    }

    public void setColorMode(String s2) {
        this.setValue(KEY_COLOR_MODE, s2);
    }

    public String getConcatenateInfo() {
        return this.getInfo(KEY_CONCATENATE);
    }

    public boolean isConcatenate() {
        return this.isSet(KEY_CONCATENATE);
    }

    public void setConcatenate(boolean b) {
        this.setValue(KEY_CONCATENATE, b);
    }

    public String getCropInfo() {
        return this.getInfo(KEY_CROP);
    }

    public boolean doCrop() {
        return this.isSet(KEY_CROP);
    }

    public void setCrop(boolean b) {
        this.setValue(KEY_CROP, b);
    }

    public String getFirstTimeInfo() {
        return this.getInfo(KEY_FIRST);
    }

    public boolean isFirstTime() {
        return this.isSet(KEY_FIRST);
    }

    public void setFirstTime(boolean b) {
        this.setValue(KEY_FIRST, b);
    }

    public String getForceThumbnailsInfo() {
        return this.getInfo(KEY_FORCE_THUMBS);
    }

    public boolean isForceThumbnails() {
        return this.isSet(KEY_FORCE_THUMBS);
    }

    public void setForceThumbnails(boolean b) {
        this.setValue(KEY_FORCE_THUMBS, b);
    }

    public String getGroupFilesInfo() {
        return this.getInfo(KEY_GROUP_FILES);
    }

    public boolean isGroupFiles() {
        return this.isSet(KEY_GROUP_FILES);
    }

    public void setGroupFiles(boolean b) {
        this.setValue(KEY_GROUP_FILES, b);
    }

    public String getUngroupFilesInfo() {
        return this.getInfo(KEY_UNGROUP_FILES);
    }

    public boolean isUngroupFiles() {
        return this.isSet(KEY_UNGROUP_FILES);
    }

    public void setUngroupFiles(boolean b) {
        this.setValue(KEY_UNGROUP_FILES, b);
    }

    public String getIdInfo() {
        return this.getInfo(KEY_ID);
    }

    public String getId() {
        return this.getValue(KEY_ID);
    }

    public void setId(String s2) {
        this.setValue(KEY_ID, s2);
    }

    public String getLocationInfo() {
        return this.getInfo(KEY_LOCATION);
    }

    public String getLocation() {
        return this.getValue(KEY_LOCATION);
    }

    public String[] getLocations() {
        return this.getPossible(KEY_LOCATION);
    }

    public boolean isLocal() {
        return LOCATION_LOCAL.equals(this.getLocation());
    }

    public boolean isHTTP() {
        return LOCATION_HTTP.equals(this.getLocation());
    }

    public boolean isOMERO() {
        return LOCATION_OMERO.equals(this.getLocation());
    }

    public void setLocation(String s2) {
        this.setValue(KEY_LOCATION, s2);
    }

    public String getOpenAllSeriesInfo() {
        return this.getInfo(KEY_OPEN_ALL_SERIES);
    }

    public boolean openAllSeries() {
        return this.isSet(KEY_OPEN_ALL_SERIES);
    }

    public void setOpenAllSeries(boolean b) {
        this.setValue(KEY_OPEN_ALL_SERIES, b);
    }

    public String getQuietInfo() {
        return this.getInfo(KEY_QUIET);
    }

    public boolean isQuiet() {
        return this.isSet(KEY_QUIET);
    }

    public void setQuiet(boolean b) {
        this.setValue(KEY_QUIET, b);
    }

    public String getShowMetadataInfo() {
        return this.getInfo(KEY_SHOW_METADATA);
    }

    public boolean isShowMetadata() {
        return this.isSet(KEY_SHOW_METADATA);
    }

    public void setShowMetadata(boolean b) {
        this.setValue(KEY_SHOW_METADATA, b);
    }

    public String getShowOMEXMLInfo() {
        return this.getInfo(KEY_SHOW_OME_XML);
    }

    public boolean isShowOMEXML() {
        return this.isSet(KEY_SHOW_OME_XML);
    }

    public void setShowOMEXML(boolean b) {
        this.setValue(KEY_SHOW_OME_XML, b);
    }

    public String getShowROIsInfo() {
        return this.getInfo(KEY_SHOW_ROIS);
    }

    public boolean showROIs() {
        return this.isSet(KEY_SHOW_ROIS);
    }

    public void setShowROIs(boolean b) {
        this.setValue(KEY_SHOW_ROIS, b);
    }

    public String getROIsModeInfo() {
        return this.getInfo(KEY_ROIS_MODE);
    }

    public String getROIsMode() {
        return this.getValue(KEY_ROIS_MODE);
    }

    public String[] getROIsModes() {
        return this.getPossible(KEY_ROIS_MODE);
    }

    public void setROIsMode(String s2) {
        this.setValue(KEY_ROIS_MODE, s2);
    }

    public String getSpecifyRangesInfo() {
        return this.getInfo(KEY_SPECIFY_RANGES);
    }

    public boolean isSpecifyRanges() {
        return this.isSet(KEY_SPECIFY_RANGES);
    }

    public void setSpecifyRanges(boolean b) {
        this.setValue(KEY_SPECIFY_RANGES, b);
    }

    public String getSplitFocalPlanesInfo() {
        return this.getInfo(KEY_SPLIT_Z);
    }

    public boolean isSplitFocalPlanes() {
        return this.isSet(KEY_SPLIT_Z);
    }

    public void setSplitFocalPlanes(boolean b) {
        this.setValue(KEY_SPLIT_Z, b);
    }

    public String getSplitTimepointsInfo() {
        return this.getInfo(KEY_SPLIT_T);
    }

    public boolean isSplitTimepoints() {
        return this.isSet(KEY_SPLIT_T);
    }

    public void setSplitTimepoints(boolean b) {
        this.setValue(KEY_SPLIT_T, b);
    }

    public String getSplitChannelsInfo() {
        return this.getInfo(KEY_SPLIT_C);
    }

    public boolean isSplitChannels() {
        return this.isSet(KEY_SPLIT_C);
    }

    public void setSplitChannels(boolean b) {
        this.setValue(KEY_SPLIT_C, b);
    }

    public String getStackFormatInfo() {
        return this.getInfo(KEY_STACK_FORMAT);
    }

    public String getStackFormat() {
        return this.getValue(KEY_STACK_FORMAT);
    }

    public String[] getStackFormats() {
        return this.getPossible(KEY_STACK_FORMAT);
    }

    public boolean isViewNone() {
        return VIEW_NONE.equals(this.getStackFormat());
    }

    public boolean isViewStandard() {
        return VIEW_STANDARD.equals(this.getStackFormat());
    }

    public boolean isViewHyperstack() {
        return VIEW_HYPERSTACK.equals(this.getStackFormat());
    }

    public boolean isViewBrowser() {
        return VIEW_BROWSER.equals(this.getStackFormat());
    }

    public boolean isViewImage5D() {
        return VIEW_IMAGE_5D.equals(this.getStackFormat());
    }

    public boolean isViewView5D() {
        return VIEW_VIEW_5D.equals(this.getStackFormat());
    }

    public void setStackFormat(String s2) {
        this.setValue(KEY_STACK_FORMAT, s2);
    }

    public String getStackOrderInfo() {
        return this.getInfo(KEY_STACK_ORDER);
    }

    public String getStackOrder() {
        return this.getValue(KEY_STACK_ORDER);
    }

    public String[] getStackOrders() {
        return this.getPossible(KEY_STACK_ORDER);
    }

    public void setStackOrder(String s2) {
        this.setValue(KEY_STACK_ORDER, s2);
    }

    public String getSwapDimensionsInfo() {
        return this.getInfo(KEY_SWAP_DIMS);
    }

    public boolean isSwapDimensions() {
        return this.isSet(KEY_SWAP_DIMS);
    }

    public void setSwapDimensions(boolean b) {
        this.setValue(KEY_SWAP_DIMS, b);
    }

    public String getUpgradeCheckInfo() {
        return this.getInfo(KEY_UPGRADE_CHECK);
    }

    public boolean doUpgradeCheck() {
        return this.isSet(KEY_UPGRADE_CHECK);
    }

    public void setUpgradeCheck(boolean b) {
        this.setValue(KEY_UPGRADE_CHECK, b);
    }

    public String getVirtualInfo() {
        return this.getInfo(KEY_VIRTUAL);
    }

    public boolean isVirtual() {
        return this.isSet(KEY_VIRTUAL);
    }

    public void setVirtual(boolean b) {
        this.setValue(KEY_VIRTUAL, b);
    }

    public String getWindowlessInfo() {
        return this.getInfo(KEY_WINDOWLESS);
    }

    public boolean isWindowless() {
        return this.isSet(KEY_WINDOWLESS);
    }

    public void setWindowless(boolean b) {
        this.setValue(KEY_WINDOWLESS, b);
    }

    public String getStitchTilesInfo() {
        return this.getInfo(KEY_STITCH_TILES);
    }

    public boolean doStitchTiles() {
        return this.isSet(KEY_STITCH_TILES);
    }

    public void setStitchTiles(boolean b) {
        this.setValue(KEY_STITCH_TILES, b);
    }

    public String getMustGroupInfo() {
        return this.getInfo(KEY_MUST_GROUP);
    }

    public boolean doMustGroup() {
        return this.isSet(KEY_MUST_GROUP);
    }

    public void setMustGroup(boolean b) {
        this.setValue(KEY_MUST_GROUP, b);
    }

    public boolean isSeriesOn(int s2) {
        if (this.openAllSeries() || this.isViewNone()) {
            return true;
        }
        return this.get(this.seriesOn, s2, s2 == 0);
    }

    public void setSeriesOn(int s2, boolean value) {
        this.set(this.seriesOn, s2, value, false);
    }

    public void clearSeries() {
        this.seriesOn.clear();
    }

    public String getInputOrder(int s2) {
        return this.get(this.inputOrder, s2, null);
    }

    public void setInputOrder(int s2, String value) {
        this.set(this.inputOrder, s2, value, null);
    }

    public int getCBegin(int s2) {
        return this.get(this.cBegin, s2, 0);
    }

    public void setCBegin(int s2, int value) {
        this.set(this.cBegin, s2, value, 0);
    }

    public int getCEnd(int s2) {
        return this.get(this.cEnd, s2, -1);
    }

    public void setCEnd(int s2, int value) {
        this.set(this.cEnd, s2, value, -1);
    }

    public int getCStep(int s2) {
        return this.get(this.cStep, s2, 1);
    }

    public void setCStep(int s2, int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Invalid C step: " + value);
        }
        this.set(this.cStep, s2, value, 1);
    }

    public int getZBegin(int s2) {
        return this.get(this.zBegin, s2, 0);
    }

    public void setZBegin(int s2, int value) {
        this.set(this.zBegin, s2, value, 0);
    }

    public int getZEnd(int s2) {
        return this.get(this.zEnd, s2, -1);
    }

    public void setZEnd(int s2, int value) {
        this.set(this.zEnd, s2, value, -1);
    }

    public int getZStep(int s2) {
        return this.get(this.zStep, s2, 1);
    }

    public void setZStep(int s2, int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Invalid Z step: " + value);
        }
        this.set(this.zStep, s2, value, 1);
    }

    public int getTBegin(int s2) {
        return this.get(this.tBegin, s2, 0);
    }

    public void setTBegin(int s2, int value) {
        this.set(this.tBegin, s2, value, 0);
    }

    public int getTEnd(int s2) {
        return this.get(this.tEnd, s2, -1);
    }

    public void setTEnd(int s2, int value) {
        this.set(this.tEnd, s2, value, -1);
    }

    public int getTStep(int s2) {
        return this.get(this.tStep, s2, 1);
    }

    public void setTStep(int s2, int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Invalid T step: " + value);
        }
        this.set(this.tStep, s2, value, 1);
    }

    public Region getCropRegion(int s2) {
        return this.get(this.cropRegion, s2, null);
    }

    public void setCropRegion(int s2, Region r) {
        this.set(this.cropRegion, s2, r, null);
    }

    public Color getCustomColor(int s2, int c) {
        List list = this.get(this.customColors, s2, null);
        int defaultColor = this.getDefaultCustomColor(c).getRGB();
        DoubleOption color = null;
        if (list != null) {
            color = this.get(list, c, null);
        }
        if (color == null) {
            color = new DoubleOption(this.getCustomColorKey(s2, c), true, "", "", defaultColor);
            color.loadOption();
        }
        return new Color((int)color.getValue());
    }

    public void setCustomColor(int s2, int c, Color color) {
        DoubleOption colorOption;
        ArrayList list = this.get(this.customColors, s2, null);
        if (list == null) {
            list = new ArrayList();
            this.set(this.customColors, s2, list, null);
        }
        if ((colorOption = (DoubleOption)this.get(list, c, null)) == null) {
            colorOption = new DoubleOption(this.getCustomColorKey(s2, c), true, "", "", 0.0);
        }
        colorOption.setValue(color.getRGB());
        this.set(list, c, colorOption, null);
        colorOption.saveOption();
    }

    public Color getDefaultCustomColor(int c) {
        return DEFAULT_COLORS[c % DEFAULT_COLORS.length];
    }

    public String getCustomColorKey(int s2, int c) {
        return s2 + "_" + c;
    }

    public boolean isUsingPatternIds() {
        return this.usePatternIds;
    }

    public void setUsingPatternIds(boolean b) {
        this.usePatternIds = b;
    }

    private <T> void set(List<T> list, int index, T value, T fillValue) {
        while (list.size() <= index) {
            list.add(fillValue);
        }
        list.set(index, value);
    }

    private <T> T get(List<T> list, int index, T defaultValue) {
        if (list.size() <= index) {
            return defaultValue;
        }
        return list.get(index);
    }

    protected boolean checkKey(String options, String key) {
        String[] tokens;
        int lIndex;
        if (options == null) {
            return false;
        }
        while ((lIndex = options.indexOf(91)) >= 0) {
            int rIndex = options.indexOf(93);
            if (rIndex < 0) {
                rIndex = options.length() - 1;
            }
            options = options.substring(0, lIndex) + options.substring(rIndex + 1);
        }
        for (String token : tokens = options.split(" ")) {
            if (!token.equals(key)) continue;
            return true;
        }
        return false;
    }
}

