/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.cache;

import java.lang.reflect.Field;

public class CacheEvent {
    public static final int SOURCE_CHANGED = 1;
    public static final int STRATEGY_CHANGED = 2;
    public static final int POSITION_CHANGED = 3;
    public static final int PRIORITIES_CHANGED = 4;
    public static final int ORDER_CHANGED = 5;
    public static final int RANGE_CHANGED = 6;
    public static final int OBJECT_LOADED = 7;
    public static final int OBJECT_DROPPED = 8;
    protected Object source;
    protected int type;
    protected int index;

    public CacheEvent(Object source, int type) {
        this(source, type, -1);
    }

    public CacheEvent(Object source, int type, int index) {
        this.source = source;
        this.type = type;
        this.index = index;
    }

    public Object getSource() {
        return this.source;
    }

    public int getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        String sType = "unknown";
        Field[] fields = this.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                if (fields[i].getInt(null) != this.type) continue;
                sType = fields[i].getName();
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return super.toString() + ": source=[" + this.source + "] type=" + sType + " index=" + this.index;
    }
}

