"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// functions/src/api-docs.lambda.ts
var api_docs_lambda_exports = {};
__export(api_docs_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(api_docs_lambda_exports);
var import_aws_sdk = require("aws-sdk");
var apiGateway;
async function handler(request) {
  apiGateway = new import_aws_sdk.APIGateway();
  try {
    const spec = await apiGateway.getExport({
      restApiId: request.requestContext.apiId,
      stageName: request.requestContext.stage,
      exportType: "oas30",
      parameters: {},
      accepts: "application/json"
    }).promise();
    return {
      statusCode: 200,
      headers: { "Content-Type": "application/json", "Content-Disposition": "inline" },
      body: spec.body.toString(),
      isBase64Encoded: false
    };
  } catch (e) {
    const error = e;
    console.log(error);
    return {
      statusCode: 500,
      headers: { "Content-Type": "application/problem+json" },
      body: JSON.stringify({
        type: "about:blank",
        title: error.code,
        status: 500,
        description: error.message
      }),
      isBase64Encoded: false
    };
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
